Imports System.IO

Public Class frmSequential
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
  Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
  Friend WithEvents mnuNew As System.Windows.Forms.MenuItem
  Friend WithEvents mnuOpen As System.Windows.Forms.MenuItem
  Friend WithEvents mnuClose As System.Windows.Forms.MenuItem
  Friend WithEvents mnuSave As System.Windows.Forms.MenuItem
  Friend WithEvents mnuExit As System.Windows.Forms.MenuItem
  Friend WithEvents mnuView As System.Windows.Forms.MenuItem
  Friend WithEvents mnuRandom As System.Windows.Forms.MenuItem
  Friend WithEvents mnuText As System.Windows.Forms.MenuItem
  Friend WithEvents rtbOutput As System.Windows.Forms.RichTextBox
  Friend WithEvents mnuNewRandom As System.Windows.Forms.MenuItem
  Friend WithEvents mnuNewText As System.Windows.Forms.MenuItem
  Friend WithEvents OpenFileDialog1 As System.Windows.Forms.OpenFileDialog
  Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.MainMenu1 = New System.Windows.Forms.MainMenu()
    Me.mnuFile = New System.Windows.Forms.MenuItem()
    Me.mnuNew = New System.Windows.Forms.MenuItem()
    Me.mnuNewRandom = New System.Windows.Forms.MenuItem()
    Me.mnuNewText = New System.Windows.Forms.MenuItem()
    Me.mnuOpen = New System.Windows.Forms.MenuItem()
    Me.mnuClose = New System.Windows.Forms.MenuItem()
    Me.MenuItem5 = New System.Windows.Forms.MenuItem()
    Me.mnuSave = New System.Windows.Forms.MenuItem()
    Me.MenuItem7 = New System.Windows.Forms.MenuItem()
    Me.mnuExit = New System.Windows.Forms.MenuItem()
    Me.mnuView = New System.Windows.Forms.MenuItem()
    Me.mnuRandom = New System.Windows.Forms.MenuItem()
    Me.mnuText = New System.Windows.Forms.MenuItem()
    Me.rtbOutput = New System.Windows.Forms.RichTextBox()
    Me.OpenFileDialog1 = New System.Windows.Forms.OpenFileDialog()
    Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog()
    Me.SuspendLayout()
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuView})
    '
    'mnuFile
    '
    Me.mnuFile.Index = 0
    Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuNew, Me.mnuOpen, Me.mnuClose, Me.MenuItem5, Me.mnuSave, Me.MenuItem7, Me.mnuExit})
    Me.mnuFile.Text = "&File"
    '
    'mnuNew
    '
    Me.mnuNew.Index = 0
    Me.mnuNew.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuNewRandom, Me.mnuNewText})
    Me.mnuNew.Text = "&New"
    '
    'mnuNewRandom
    '
    Me.mnuNewRandom.Index = 0
    Me.mnuNewRandom.Text = "&Random"
    '
    'mnuNewText
    '
    Me.mnuNewText.Index = 1
    Me.mnuNewText.Text = "&Text"
    '
    'mnuOpen
    '
    Me.mnuOpen.Index = 1
    Me.mnuOpen.Text = "&Open"
    '
    'mnuClose
    '
    Me.mnuClose.Index = 2
    Me.mnuClose.Text = "&Close"
    '
    'MenuItem5
    '
    Me.MenuItem5.Index = 3
    Me.MenuItem5.Text = "-"
    '
    'mnuSave
    '
    Me.mnuSave.Index = 4
    Me.mnuSave.Text = "&Save"
    '
    'MenuItem7
    '
    Me.MenuItem7.Index = 5
    Me.MenuItem7.Text = "-"
    '
    'mnuExit
    '
    Me.mnuExit.Index = 6
    Me.mnuExit.Text = "E&xit"
    '
    'mnuView
    '
    Me.mnuView.Index = 1
    Me.mnuView.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuRandom, Me.mnuText})
    Me.mnuView.Text = "&View"
    '
    'mnuRandom
    '
    Me.mnuRandom.Index = 0
    Me.mnuRandom.Text = "&Random"
    '
    'mnuText
    '
    Me.mnuText.Index = 1
    Me.mnuText.Text = "&Sequential"
    '
    'rtbOutput
    '
    Me.rtbOutput.Location = New System.Drawing.Point(16, 16)
    Me.rtbOutput.Name = "rtbOutput"
    Me.rtbOutput.Size = New System.Drawing.Size(440, 208)
    Me.rtbOutput.TabIndex = 0
    Me.rtbOutput.Text = ""
    '
    'OpenFileDialog1
    '
    Me.OpenFileDialog1.CheckFileExists = False
    '
    'SaveFileDialog1
    '
    Me.SaveFileDialog1.FileName = "doc1"
    '
    'frmSequential
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.BackColor = System.Drawing.Color.White
    Me.ClientSize = New System.Drawing.Size(472, 273)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.rtbOutput})
    Me.Menu = Me.MainMenu1
    Me.Name = "frmSequential"
    Me.Text = "Read/Write Sequential File"
    Me.WindowState = System.Windows.Forms.FormWindowState.Maximized
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub frmSequential_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    rtbOutput.Visible = False
  End Sub


  Private Sub SizeRichTextbox()
    Dim ClientSize, BoxSize As Size

    ClientSize = Me.Size
    BoxSize.Height = ClientSize.Height - 100
    BoxSize.Width = ClientSize.Width - 100
    rtbOutput.Size = BoxSize

  End Sub

  Private Sub mnuSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuSave.Click
    ' Purpose:  This routine is responsible for saving the content of
    '           the data file
    Dim NewFileName As String
    Dim NewFile As SaveFileDialog = New SaveFileDialog()
    Dim MyChoice As DialogResult

    With NewFile                            ' Initialize the dialog control
      .Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
      .FilterIndex = 1                      ' Assume text files
      .DefaultExt = "txt"                   ' Ditto
      .InitialDirectory = "C:\Temp\"
      .OverwritePrompt = False                ' Ask before overwriting
      .Title = "Save Text Data File"
    End With

    MyChoice = NewFile.ShowDialog           ' What did they do?

    If MyChoice = DialogResult.Cancel Then  ' Bail out?
      Exit Sub
    Else
      NewFileName = NewFile.FileName
    End If

    If NewFileName.Length > 0 Then
      Try
        Dim MyTextData As StreamWriter = New StreamWriter(NewFileName, False)

        MyTextData.Write(rtbOutput.Text)    ' Write the data
        MyTextData.Close()                  ' Close the stream
        MyTextData = Nothing                ' Release it
      Catch
        Beep()
        MessageBox.Show("Something went wrong while writing of the data")
      End Try
    End If
  End Sub

  Private Sub mnuExit_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles mnuExit.Click
    Me.Dispose()
  End Sub

  Private Sub mnuOpen_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles mnuOpen.Click
    Dim FileName As String

    rtbOutput.Clear()
    With OpenFileDialog1
      .Filter = "Random files (*.dat)|*.dat|Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
      .FilterIndex = 2
      .InitialDirectory = "C:\Temp\"
      .Title = "Select File"
    End With

    Try
      If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
        FileName = OpenFileDialog1.FileName
      Else
        Exit Sub          ' They didn't want to continue...
      End If
      Select Case OpenFileDialog1.FilterIndex
        Case 1            ' Random
          Dim MyRandom As New frmRandom()
          MyRandom.FileName = FileName
          MyRandom.Show()
        Case 2            ' Text
          Dim MyReadText As StreamReader = New StreamReader(FileName)
          rtbOutput.Visible = True
          SizeRichTextbox()
          rtbOutput.Text = MyReadText.ReadToEnd()
          MyReadText.Close()
          MyReadText = Nothing
        Case Else
      End Select
    Catch
      MessageBox.Show("Something's amiss...", "File Read Error")
    End Try
  End Sub

  Private Sub mnuClose_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles mnuClose.Click
    rtbOutput.Clear()
    rtbOutput.Visible = False
  End Sub

  Private Sub mnuNewText_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuNewText.Click
    rtbOutput.Clear()
    SizeRichTextbox()
    rtbOutput.Visible = True
    rtbOutput.Focus()

  End Sub

  Private Sub mnuNewRandom_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuNewRandom.Click
    Dim MyRandom As New frmRandom()
    Dim FileName As String

    rtbOutput.Visible = False

    With OpenFileDialog1
      .Filter = "Random files (*.dat)|*.dat|All Files (*.*)|*.*"
      .FilterIndex = 1
      .InitialDirectory = "C:\Temp\"
      .Title = "Select Random File"
    End With

    Try
      If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
        FileName = OpenFileDialog1.FileName
        Dim MyFile As FileStream = New FileStream(FileName, FileMode.Create, FileAccess.ReadWrite)
        MyFile.Close()
        MyFile = Nothing
      Else
        Exit Sub          ' They didn't want to continue...
      End If
    Catch
      MessageBox.Show("Could not access file")
    End Try
    MyRandom.FileName = FileName
    MyRandom.Show()

  End Sub
End Class
